/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.client.gui.screen.ingame;

import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.cca.GameWorldComponent;
import dev.doctor4t.wathe.client.gui.StoreRenderer;
import dev.doctor4t.wathe.client.gui.screen.ingame.LimitedHandledScreen;
import dev.doctor4t.wathe.game.GameConstants;
import dev.doctor4t.wathe.util.ShopEntry;
import dev.doctor4t.wathe.util.StoreBuyPayload;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class LimitedInventoryScreen
extends LimitedHandledScreen<class_1723> {
    public static final class_2960 BACKGROUND_TEXTURE = Wathe.id("textures/gui/container/limited_inventory.png");
    @NotNull
    public static final class_2960 ID = Wathe.id("textures/gui/game.png");
    public final class_746 player;

    public LimitedInventoryScreen(@NotNull class_746 player) {
        super(player.field_7498, player.method_31548(), (class_2561)class_2561.method_43473());
        this.player = player;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (!((GameWorldComponent)GameWorldComponent.KEY.get((Object)this.player.method_37908())).canUseKillerFeatures((class_1657)this.player)) {
            return;
        }
        List<ShopEntry> entries = GameConstants.SHOP_ENTRIES;
        int apart = 38;
        int x = this.field_22789 / 2 - entries.size() * apart / 2 + 9;
        int y = this.y - 46;
        for (int i = 0; i < entries.size(); ++i) {
            this.method_37063((class_364)new StoreItemWidget(this, x + apart * i, y, entries.get(i), i));
        }
    }

    @Override
    protected void drawBackground(@NotNull class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25302(BACKGROUND_TEXTURE, this.x, this.y, 0, 0, this.backgroundWidth, this.backgroundHeight);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)context.method_51421() / 2.0f, (float)context.method_51443(), 0.0f);
        float scale = 0.28f;
        context.method_51448().method_22905(scale, scale, 1.0f);
        int height = 254;
        int width = 497;
        context.method_51448().method_46416(0.0f, -230.0f, 0.0f);
        boolean xOffset = false;
        boolean yOffset = false;
        context.method_48466(ID, (int)((float)xOffset - (float)width / 2.0f), (int)((float)xOffset + (float)width / 2.0f), (int)((float)yOffset - (float)height / 2.0f), (int)((float)yOffset + (float)height / 2.0f), 0, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        context.method_51448().method_22909();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.drawMouseoverTooltip(context, mouseX, mouseY);
        StoreRenderer.renderHud(this.field_22793, this.player, context, delta);
    }

    public static class StoreItemWidget
    extends class_4185 {
        public final LimitedInventoryScreen screen;
        public final ShopEntry entry;

        public StoreItemWidget(LimitedInventoryScreen screen, int x, int y, @NotNull ShopEntry entry, int index) {
            super(x, y, 16, 16, entry.stack().method_7964(), a -> ClientPlayNetworking.send((class_8710)new StoreBuyPayload(index)), field_40754);
            this.screen = screen;
            this.entry = entry;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            context.method_52706(this.entry.type().getTexture(), this.method_46426() - 7, this.method_46427() - 7, 30, 30);
            context.method_51427(this.entry.stack(), this.method_46426(), this.method_46427());
            if (this.method_49606()) {
                this.screen.renderLimitedInventoryTooltip(context, this.entry.stack());
                this.drawShopSlotHighlight(context, this.method_46426(), this.method_46427(), 0);
            }
            class_5250 price = class_2561.method_43470((String)(this.entry.price() + "\ue781"));
            context.method_51438(this.screen.field_22793, (class_2561)price, this.method_46426() - 4 - this.screen.field_22793.method_27525((class_5348)price) / 2, this.method_46427() - 9);
        }

        private void drawShopSlotHighlight(class_332 context, int x, int y, int z) {
            int color = -1862287543;
            context.method_51740(class_1921.method_51785(), x, y, x + 16, y + 14, color, color, z);
            context.method_51740(class_1921.method_51785(), x, y + 14, x + 15, y + 15, color, color, z);
            context.method_51740(class_1921.method_51785(), x, y + 15, x + 14, y + 16, color, color, z);
        }

        public void method_48589(class_332 context, class_327 textRenderer, int color) {
        }
    }
}

